<!doctype html>
<html class="no-js" lang="en">

<head>
    @include('layouts.css')
</head>

<body>
    
    @include('layouts.header')
   



    <!-- main-area -->
    <main class="main-area fix">
  <!-- breadcrumb-area -->
        <section class="breadcrumb__area">
            <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb__bg.jpg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <h2 class="title">Développement d'applications</h2>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                    <a href="{{ url('url') }}">Accueil</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                <span property="itemListElement" typeof="ListItem">Développement d'applications</span>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb-area-end -->

         <!-- faq-area -->
        <section class="faq__area section-py-130">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-5">
                        <div class="faq__content">
                            <div class="section__title mb-20">
                                <span class="sub-title">Développement d'applications</span>
                                <h2 class="title">Nos compétences en développement d’applications</h2>
                            </div>
                            <p>Nos compétences en développement d’applications couvrent l’ensemble du cycle de vie d’un projet, de l’analyse des besoins à la mise en production. Nous concevons des solutions performantes, sécurisées et évolutives, adaptées aux exigences métiers de nos clients. Notre expertise inclut le développement web et mobile, l’intégration d’API, l’automatisation des processus et l’optimisation des performances pour garantir des applications fiables et intuitives.</p>
                            <div class="faq__img">
                                <img src="assets/img/images/faq_img.jpg" alt="img">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="faq__wrap">
                            <div class="accordion" id="accordionExample">
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            🌐 Développement d’applications web
                                        </button>
                                    </h2>
                                    <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <ul class="list-wrap about__list-item-two">
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Applications internes et métiers
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Plateformes SaaS (Software as a Service)
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Outils de gestion et dashboards
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Espace client / Portails sécurisés
                                                </li>

                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Solutions collaboratives
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Interfaces administratives (back-office)
                                                </li>
                                            </ul>

                                            <p><strong><br>Avantage :</strong> Le développement d’applications web offre une flexibilité et une accessibilité incomparables, permettant aux utilisateurs d’accéder à leurs outils et données depuis n’importe quel appareil connecté à Internet, sans installation complexe. Les mises à jour sont centralisées, garantissant des versions toujours à jour et sécurisées. Conçues sur mesure selon les besoins métiers, ces applications sont évolutives, rapides à déployer et faciles à intégrer avec des systèmes existants, offrant ainsi une solution performante et durable pour soutenir la croissance des entreprises. </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            📱 Développement mobile (Android / iOS)
                                        </button>
                                    </h2>
                                    <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <ul class="list-wrap about__list-item-two">
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Applications mobiles natives
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Applications hybrides (Flutter / React Native)
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Interfaces fluides et optimisées
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Synchronisation en temps réel
                                                </li>

                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Notifications push
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Fonctionnement hors-ligne (offline mode)
                                                </li>
                                            </ul>

                                            <p><strong><br>Avantage :</strong> Le développement mobile permet de créer des applications natives pour Android et iOS, offrant une expérience utilisateur fluide, rapide et optimisée. Ces applications facilitent l’accès à vos services à tout moment et en tout lieu, renforcent l’engagement des utilisateurs et permettent d’exploiter pleinement les fonctionnalités des smartphones, comme les notifications, la géolocalisation ou l’appareil photo, pour répondre efficacement aux besoins de votre entreprise. </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            🧩 Création d’interfaces modernes & UX design
                                        </button>
                                    </h2>
                                    <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <ul class="list-wrap about__list-item-two">
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Design ergonomique adapté à vos utilisateurs
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Maquettes UI/UX avant développement
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Expérience fluide, claire et intuitive
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Responsive design (mobile, tablette, desktop)
                                                </li>

                                                
                                            </ul>

                                            <p><strong><br>Avantage :</strong> La création d’interfaces modernes et centrées sur l’expérience utilisateur (UX) permet de concevoir des applications intuitives, esthétiques et faciles à utiliser. Un design soigné améliore la navigation, réduit les frictions et augmente la satisfaction des utilisateurs, tout en renforçant l’image de marque. En combinant ergonomie et esthétisme, nous transformons chaque interaction en une expérience agréable et mémorable. </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            ⚙️ Back-end robuste & évolutif
                                        </button>
                                    </h2>
                                    <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <ul class="list-wrap about__list-item-two">
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Architectures modernes et sécurisées
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Gestion des utilisateurs et permissions
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Systèmes d’authentification avancés
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                API REST / Webhooks
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Traitement de gros volumes de données
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Automatisation des tâches
                                                </li>

                                                
                                            </ul>

                                            <p><strong><br>Avantage :</strong> Un back-end robuste et évolutif garantit que votre application fonctionne de manière fiable, même avec une forte charge d’utilisateurs ou des volumes de données importants. Il permet d’ajouter facilement de nouvelles fonctionnalités, d’optimiser les performances et d’assurer la sécurité des données. Grâce à une architecture solide, votre application peut croître avec votre entreprise sans compromis sur la stabilité ou la rapidité. </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                            🔐 Sécurité & fiabilité
                                        </button>
                                    </h2>
                                    <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <ul class="list-wrap about__list-item-two">
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Connexions sécurisées (HTTPS / SSL)
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Chiffrement des données sensibles
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Audit logs et contrôle d’accès
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                API REST / Webhooks
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Sauvegardes automatiques
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Protection contre injections / attaques courantes
                                                </li>

                                                
                                            </ul>

                                            <p><strong><br>Avantage :</strong> Assurer la sécurité et la fiabilité de vos applications protège vos données sensibles et celles de vos utilisateurs contre les cybermenaces. Une architecture fiable minimise les risques de pannes et garantit un fonctionnement continu, renforçant la confiance des utilisateurs. En combinant protection avancée et stabilité, vos applications offrent une expérience sûre et sereine à chaque utilisation. </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseFive2" aria-expanded="false" aria-controls="collapseFive">
                                            ☁️ Hébergement & infrastructure
                                        </button>
                                    </h2>
                                    <div id="collapseFive2" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <ul class="list-wrap about__list-item-two">
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Déploiement cloud (AWS, OVH, DigitalOcean…)
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Haute disponibilité
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Gestion des serveurs et monitoring
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                Optimisation des performances
                                                </li>
                                                <li>
                                                    <div class="icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="11" viewBox="0 0 14 11" fill="none">
                                                            <path d="M12.091 2L5.091 9L1.90918 5.81818" stroke="currentColor" stroke-width="2.1875"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </div>
                                                    Mise en cache & CDN
                                                </li>
                                                

                                                
                                            </ul>

                                            <p><strong><br>Avantage :</strong> Un hébergement performant et une infrastructure optimisée assurent la disponibilité, la rapidité et la scalabilité de vos applications. Que ce soit pour gérer un trafic élevé ou stocker de grandes quantités de données, une infrastructure cloud fiable garantit un accès fluide et sécurisé à vos services, tout en facilitant leur maintenance et leur évolution. </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- faq-area-end -->
         <!-- features-area -->
        <section class="features__area-three section-py-130">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="section__title text-center mb-40">
                            <span class="sub-title">Développement d'applications</span>
                            <h2 class="title">Avantages pour votre entreprise</h2>
                        </div>
                    </div>
                </div>
                <div class="row gutter-y-24 justify-content-center">
                    <div class="col-xl-3 col-lg-3 col-sm-6">
                        <div class="features__item-two">
                            <div class="features__icon-two">
                                🚀
                            </div>
                            <div class="features__content-four">
                                <h3 class="title"> Une solution faite pour vous</h3>
                                <p>Chaque application est développée selon vos besoins exacts : fonctionnalités, design, workflows, permissions…</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-sm-6">
                        <div class="features__item-two">
                            <div class="features__icon-two">
                                💡
                            </div>
                            <div class="features__content-four">
                                <h3 class="title">Amélioration de l’efficacité interne</h3>
                                <p> Moins de tâches manuelles, plus d’automatisation et une meilleure gestion des informations.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-sm-6">
                        <div class="features__item-two">
                            <div class="features__icon-two">
                               📈
                            </div>
                            <div class="features__content-four">
                                <h3 class="title">Application évolutive</h3>
                                <p> Votre solution peut grandir et s'adapter facilement : ajout de modules, nouvelles fonctionnalités, nouvelles intégrations.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-sm-6">
                        <div class="features__item-two">
                            <div class="features__icon-two">
                                🎯
                            </div>
                            <div class="features__content-four">
                                <h3 class="title">Un contrôle total</h3>
                                <p> Vous définissez les fonctionnalités, l’infrastructure et les règles de sécurité.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-sm-6">
                        <div class="features__item-two">
                            <div class="features__icon-two">
                                🔗 
                            </div>
                            <div class="features__content-four">
                                <h3 class="title">Intégrée à vos outils existants</h3>
                                <p>CRM ,ERP ,Téléphonie (Phonéris) ,Plateformes marketing ,Comptabilité ,Site web, API externes</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-9 col-lg-3 col-sm-6">
                        <div class="features__item-two">
                            <div class="features__icon-two">
                                🔹 
                            </div>
                            <div class="features__content-four">
                                <h3 class="title">Cas d’usage</h3>
                                <p>🔸 Plateformes SaaS
Solutions multi-utilisateurs, facturation, espace client, gestion d’abonnements.
🔸 Outils internes métiers
Applications pour RH, logistique, finance, production, support…
🔸 Applications mobiles professionnelles
Suivi terrain, interventions, reporting en temps réel…
🔸 Portails clients & partenaires
Portail sécurisé pour gérer documents, tickets, demandes, projets…
🔸 Dashboards & reporting
Visualisation de KPI, graphiques dynamiques, tableaux de bord interactifs.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- features-area-end -->

        
    </main>
    <!-- main-area-end -->

    @include('layouts.footer')



    @include('layouts.js')



    
</body>

</html>